<?php
/**
 * functions and definitions
 */

function dental_child_scripts() {
 
	
	wp_enqueue_style( 'style-main', get_template_directory_uri() . '/style.css' );	
	 wp_enqueue_style( 'tpbc-style', get_stylesheet_uri() );
}
add_action( 'wp_enqueue_scripts', 'dental_child_scripts', 100);




function fn_testimonial_posttype() { 
	register_post_type( 'testimonial',

		array(
			'labels' => array(
				'name' => __( 'Testimonials' ),
				'singular_name' => __( 'Testimonial')
			),
			'public' => true,
			'has_archive' => true,
			'rewrite' => array('slug' => 'testimonial','with_front' => false), 
			'supports' => array( 'title', 'revisions','editor','excerpt','thumbnail' ),
			
		)
	);
}
add_action( 'init', 'fn_testimonial_posttype' );


function fn_testimonial_slider(){

		$args = array( 
			'posts_per_page' => -1,
			'post_type' =>'testimonial',
			'post_status' =>'publish',
			'orderby' => 'date', 
			'order' => 'ASC'
		);
		
		$the_query = new WP_Query( $args );
		ob_start();
		?>
		<section class="testimonial_main">
         <div class="container-fluid">
             <div class="row">
                <div class="col-md-12">
                    <div class="testimonial_slider single_slide text-center">
					 <?php 	while ( $the_query->have_posts() ) : $the_query->the_post();	?>
                       <div class="doctor__slider_inner">
							<h3 class="testimonial_title"><?php the_title(); ?></h3>
							<div class="testimonial_txt"><?php the_content(); ?></div>
						</div>
						<?php	
							endwhile;	
							wp_reset_postdata();
						?>
                    </div>
                </div>
             </div>
         </div> 
     </section> 
	<?php
	return ob_get_clean();
}
add_shortcode("testimonial_slider","fn_testimonial_slider"); 