<?php
/**
 * The Header for our theme.
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
    <head>
        <meta charset="<?php bloginfo( 'charset' ); ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
		<link rel="profile" href="http://gmpg.org/xfn/11">
		<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">	
		<?php echo base64_decode(get_theme_mod( 'google_js_code')); ?>		
		 <?php wp_head(); ?>	
		<?php echo base64_decode(get_theme_mod( 'header_js_code')); ?>		
	</head> 
	<body <?php body_class(); ?>>
		<?php  echo base64_decode(get_theme_mod( 'body_js_code')); ?>
		<?php 
			global $post;
			$post_slug = $post->post_name;
		?>
		<div id="page" class="site page-<?php echo $post_slug; ?>">
			<?php do_action( 'before' ); ?>
			<header id="masthead" class="site-header header-transparent" role="banner" >
				<?php if ( is_active_sidebar( 'hello-sidebar' ) ) : ?>
					<div id="hellobar-bar" class="hellobar-element"><?php dynamic_sidebar("hello-sidebar"); ?></div>	
				<?php endif; ?> 
				<?php if ( is_active_sidebar( 'top-header-left-sidebar' ) ) : ?>
					<div class="top-header">
						<div class="container-fluid">
							<div class="row">
								<div class="col-md-3 d-block d-lg-none"><a class="navbar-brand header-image" href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><img src="<?php header_image(); ?>" alt="<?php bloginfo( 'name' ); ?>" border="0" /></a></div>	
								<div class="col-md-12"><?php dynamic_sidebar("top-header-left-sidebar"); ?></div>	
							</div>
						</div>
					</div>
				<?php endif; ?> 
			
				<nav class="navbar navbar-expand-md navbar-light">     
					<a class="navbar-brand header-image d-none d-lg-block" href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><img src="<?php header_image(); ?>" alt="<?php bloginfo( 'name' ); ?>" border="0" /></a>
			
					<?php
						wp_nav_menu( array(
						 'theme_location'    => 'primary',
						 'depth'             => 3,
						 'container'         => 'div',
						 'container_class'   => 'collapse navbar-collapse',
						 'container_id'      => 'bs-example-navbar-collapse-1',
						 'menu_class'        => 'nav navbar-nav ml-lg-auto',  
						 'fallback_cb'       => 'WP_Bootstrap_Navwalker::fallback',
						 'walker'            => new WP_Bootstrap_Navwalker())
					    ); 
					?>    
				</nav>  
			</header><!-- #masthead -->            

			<div id="content" class="site-content">
		 <?php 
			 /* content-banner.php for all the banner */
			 get_template_part( 'content', 'banner' ); 
		 ?> 
		 
		<?php 
			/* Homepage Slider */
			if(is_front_page()){
				echo do_shortcode("[homepage_slider]"); 
			} 
		?>
		 <?php if(is_home() || is_singular('post')){ ?>
			<div class="blogcustom">
		<?php } ?>
		<div class="container-fluid">
			<div class="row"> 