<?php
/**
 * The Header for our theme.
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
    <head>
        <meta charset="<?php bloginfo( 'charset' ); ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
		<link rel="profile" href="http://gmpg.org/xfn/11">
		<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">	
		<?php echo base64_decode(get_theme_mod( 'google_js_code')); ?>		
		 <?php wp_head(); ?>	
		<?php echo base64_decode(get_theme_mod( 'header_js_code')); ?>	

<script>
jQuery(document).ready(function () {
jQuery('.dropdown-menu a.dropdown-toggle').on('click', function(e) {
  if (!jQuery(this).next().hasClass('show')) {
    jQuery(this).parents('.dropdown-menu').first().find('.show').removeClass("show");
  }
  var $subMenu = jQuery(this).next(".dropdown-menu");
  $subMenu.toggleClass('show');


  jQuery(this).parents('li.nav-item.dropdown.show').on('hidden.bs.dropdown', function(e) {
    jQuery('.dropdown-submenu .show').removeClass("show");
  });


  return false;
});
});

</script>
<style>
.dropdown-submenu {
  position: relative;
}

.dropdown-submenu a::after {
  transform: rotate(-90deg);
  position: absolute;
  right: 6px;
  top: .8em;
}

.dropdown-submenu .dropdown-menu {
  top: 0;
  left: 100%;
  margin-left: .1rem;
  margin-right: .1rem;
}
/* to show the arrow */
.dropdown-submenu a::after {
  transform: rotate(-90deg);
  position: absolute;
  right: 6px;
  top: .8em;
}
.dropdown-toggle a::after{
  transform: rotate(-90deg);
  position: absolute;
  right: 6px;
  top: .8em;
}
</style>
	</head> 
	<body <?php body_class(); ?>>
		<?php  echo base64_decode(get_theme_mod( 'body_js_code')); ?>
		<?php 
			global $post;
			$post_slug = $post->post_name;
		?>
		<div id="page" class="site page-<?php echo $post_slug; ?>">
			<?php do_action( 'before' ); ?>
            
            <header id="masthead" class="site-header header-transparent" role="banner" >
			
			<div class="show-mobile d-md-none">
			 
						<a class="navbar-brand header-image d-block d-md-none text-center" href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><img src="<?php header_image(); ?>" alt="<?php bloginfo( 'name' ); ?>" border="0" /></a>
			
				<?php if ( is_active_sidebar( 'top-header-left-sidebar' ) ) : ?>
					<div class="top-header">
						<div class="container-fluid">
							<div class="row">
								<div class="col-md-12"><div class="contact-right d-md-none d-block"> <?php dynamic_sidebar("top-header-left-sidebar"); ?></div>	</div>   
							</div>
						</div>
					</div>
				<?php endif; ?> 
			   
			  </div>  
			
			
				<?php if ( is_active_sidebar( 'hello-sidebar' ) ) : ?>
					<div id="hellobar-bar" class="hellobar-element"><?php dynamic_sidebar("hello-sidebar"); ?></div>	
				<?php endif; ?> 
				<?php if ( is_active_sidebar( 'top-header-left-sidebar' ) ) : ?>
					<div class="hide-mobile top-header">
						<div class="container-fluid">
							<div class="row">
								<div class="col-md-12"><?php dynamic_sidebar("top-header-left-sidebar"); ?></div>	
								<!-- <div class="col-md-6"><?php //dynamic_sidebar("top-header-Right-sidebar"); ?></div> -->
							</div>
						</div>
					</div>
				<?php endif; ?> 
            
								<nav class="navbar navbar-expand-xl navbar-light">                   	                          
                     	<a class="navbar-brand header-image hide-mobile" href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><img src="<?php header_image(); ?>" alt="<?php bloginfo( 'name' ); ?>" border="0" /></a>                                 
						<button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#bs-example-navbar-collapse-1" aria-controls="bs-example-navbar-collapse-1" aria-expanded="false" aria-label="Toggle navigation"><span class="navbar-toggler-icon"></span></button>
											<?php
														wp_nav_menu( array(
														'menu'              => 'menu-1',
														'theme_location'    => 'primary',
														'depth'             => 3,
														'container'         => 'div',
														'container_class'   => 'collapse navbar-collapse',
														'container_id'      => 'bs-example-navbar-collapse-1',
														'menu_class'        => 'nav navbar-nav ml-auto',  
														'fallback_cb'       => 'WP_Bootstrap_Navwalker::fallback',
														'walker'            => new WP_Bootstrap_Navwalker())
											); 
											?>    
											
                </nav>  
        </header><!-- #masthead -->  
         
		
			<div id="content" class="site-content">
		 <?php 
			 /* content-banner.php for all the banner */
			 get_template_part( 'content', 'banner' ); 
		 ?> 
		 
		<?php 
			/* Homepage Slider */
			if(is_front_page()){
				echo do_shortcode("[homepage_slider]"); 
			} 
		?>
		
		<div class="container-fluid">
			<div class="row"> 