<?php
/**
 * ACF Fields for various post-types.
 */

 function my_acf_add_local_field_groups() {
	if( function_exists('acf_add_local_field_group') ):
	acf_add_local_field_group(array(
		'key' => 'group_1',
		'title' => 'Team Member Fields',
		'fields' => array (
			array (
				'key' => 'designation',
				'label' => 'Designation',
				'name' => 'designation',
				'type' => 'text',
			)
		
		),
		'location' => array (
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'team-member',
				),
			),
		),
		'position' => 'acf_after_title',
	));	
	
	
	
	acf_add_local_field_group(array(
		'key' => 'group_3',
		'title' => 'Banner Fields',
		'fields' => array (
			
			array (
				'key' => 'banner_text',
				'label' => 'Banner Text',
				'name' => 'banner_text',
				'type' => 'text',
			),
			array (
					'key' => 'show_featured_image_in_single_post',
					'label' => 'Show Featured Image in Single Post',
					'name' => 'show_featured_image_in_single_post',
					'type' => 'true_false',
				)
		
		),
		'location' => array (
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'post',
				)
			),
		),
		'position' => 'acf_after_title',
	));
	
	acf_add_local_field_group(array(
		'key' => 'group_4',
		'title' => 'Banner Fields',
		'fields' => array (
			array (
				'key' => 'banner_text',
				'label' => 'Banner Text',
				'name' => 'banner_text',
				'type' => 'text',
			)
		
		),
		'location' => array(
			array(
				array(
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'page',
				),
				array(
					'param' => 'page',
					'operator' => '!=',
					'value' => '965',
				),
			),
		),
		'position' => 'acf_after_title',
	));
	
	
	endif;
}

add_action('acf/init', 'my_acf_add_local_field_groups');