<?php
/**
 * functions and definitions
 */

require_once( 'library/setup.php' );
require_once( 'library/widgets.php' ); 
require_once( 'library/neweb.php' );
require_once('library/wp-bootstrap-navwalker.php');
require_once('library/acf.php');


/* Implement the Custom Header feature. */
require get_template_directory() . '/library/underscores/custom-header.php';
/* Custom template tags for this theme. */ 
require get_template_directory() . '/library/underscores/template-tags.php';

/* Custom functions that act independently of the theme templates. */
require get_template_directory() . '/library/underscores/extras.php';

/* Customizer additions. */
require get_template_directory() . '/library/underscores/customizer.php';

/* Load Jetpack compatibility file. */
require get_template_directory() . '/library/underscores/jetpack.php';


/* Enqueue scripts and styles */
function tpbc_scripts() {
    /* load tpbc styles */
    wp_enqueue_style( 'tpbc-style', get_stylesheet_uri() );
    /* load bootstrap for WordPress css */
	wp_enqueue_style( 'dental_main', get_template_directory_uri() . '/dental_main.css' );	
	wp_enqueue_style( 'tpbc-bootstrap', get_template_directory_uri() . '/assets/css/bootstrap/bootstrap.min.css' ); 
	wp_enqueue_style( 'tpbc-bootstrap-reboot', get_template_directory_uri() . '/assets/css/bootstrap/bootstrap-reboot.min.css' );
    wp_enqueue_style( 'tpbc-muli', 'https://fonts.googleapis.com/css?family=Muli:300,400,600,700' ); 

  
 
    /* load bootstrap for WordPress css */
    wp_enqueue_style( 'tpbc-bootstrapwp', get_template_directory_uri() . '/assets/css/bootstrap-wp.css' );
	/* load bootstrap.js */
	wp_enqueue_script('tpbc-bootstrapjs', get_template_directory_uri().'/assets/js/bootstrap/bootstrap.bundle.min.js#asyncload', array('jquery') );
	wp_enqueue_script('tpbc-popperjs', get_template_directory_uri().'/assets/js/bootstrap/popper.min.js#asyncload', array('jquery') );
  
   
	/*******************************************/
	/*Slick Slider*/
	
	wp_enqueue_style( 'slick-css', get_template_directory_uri() .'/slick/slick.css' ); 
	wp_enqueue_style( 'slick-theme-css', get_template_directory_uri() .'/slick/slick-theme.css' ); 
	
	/*******************************************/
	wp_enqueue_script( 'dental-js', get_template_directory_uri() .'/assets/js/js_dental.js#asyncload', array(), '1.5.7', false );
	/*******************************************/
    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) { 	wp_enqueue_script( 'comment-reply' );    }

    /*load keyboard-image-navigation.js */
    if ( is_singular() && wp_attachment_is_image() ) {
        wp_enqueue_script( 'tpbc-keyboard-image-navigation', get_template_directory_uri() . '/assets/js/keyboard-image-navigation.js#asyncload', array( 'jquery' ), '20120202' ); 
    } 
}
add_action( 'wp_enqueue_scripts', 'tpbc_scripts', 100);

/**************************************************************************************************/
function dental_async_scripts($url)
{
    if ( strpos( $url, '#asyncload') === false )
        return $url;
    else if ( is_admin() )
        return str_replace( '#asyncload', '', $url );
    else
	return str_replace( '#asyncload', '', $url )."' async='async";
    }
add_filter( 'clean_url', 'dental_async_scripts', 11, 1 );

/**************************************************************************************************/

add_theme_support( 'post-thumbnails' );

add_action( 'after_setup_theme', 'aw_custom_add_image_sizes' );
function aw_custom_add_image_sizes() {
    add_image_size( 'small', 300, 9999 ); /*  300px wide unlimited height */
    add_image_size( 'medium-small', 450, 9999 ); /*  300px wide unlimited height */
    add_image_size( 'xl', 1200, 9999 ); /*  1200px wide unlimited height */
    add_image_size( 'xxl', 2000, 9999 ); /*  2000px wide unlimited height */
    add_image_size( 'xxxl', 3000, 9999 ); /*  3000px wide unlimited height */
  	add_image_size( 'home_blog_thumb', 822, 768, array( 'center', 'center' ) );
	add_image_size( 'home_team_thumb', 548, 512, array( 'center', 'center' ) );  
	add_image_size( 'recent_post_thumb', 50, 50, array( 'center', 'center' ) );  
}

add_filter( 'image_size_names_choose', 'aw_custom_add_image_size_names' );
function aw_custom_add_image_size_names( $sizes ) {
  return array_merge( $sizes, array(
    'small' => __( 'Small' ),
    'medium-small' => __( 'Medium Small' ),
    'xl' => __( 'Extra Large' ),
    'xxl' => __( '2x Extra Large' ),
    'xxxl' => __( '3x Extra Large' ),
    'portfolio_full' => __( 'Portfolio Full Size' ),
  ) );
}
/*******************************************/
function dental_post_thumbnail( $post_id, $size = 'image', $class = '' )
{
  $thumbnail = wp_get_attachment_image_src( get_post_thumbnail_id( $post_id ), $size )[0];
  $thumbnail_2x = wp_get_attachment_image_src( get_post_thumbnail_id( $post_id ), $size . '-2x' )[0];
  $thumbnail_3x = wp_get_attachment_image_src( get_post_thumbnail_id( $post_id ), $size . '-3x' )[0];

  $image  = '<img src="' . $thumbnail . '"';
  $image .= ( $thumbnail_2x && $thumbnail_3x ?  ' srcset="' : '' ); // open srcset
  $image .= ( $thumbnail_2x ? $thumbnail_2x . ' 2x' : '' );
  $image .= ( $thumbnail_2x && $thumbnail_3x ? ', ' : '' );
  $image .= ( $thumbnail_3x ? $thumbnail_3x . ' 3x' : '' );
  $image .= ( $thumbnail_2x && $thumbnail_3x ?  '"' : '' ); // close srcset
  $image .= ( $class ? ' class="' . esc_attr($class) . '"' : '' );
  $image .= ' sizes="auto">';

  return $image;
}

/**************************************************************************************************/
function fn_team_member_posttype() { 
	register_post_type( 'team-member',

		array(
			'labels' => array(
				'name' => __( 'Team Members' ),
				'singular_name' => __( 'Team Member ')
			),
			'public' => true,
			'has_archive' => true,
			'rewrite' => array('slug' => 'team-member'),
			'supports' => array( 'title', 'revisions','editor','excerpt','thumbnail' ),
		)
	);
}
add_action( 'init', 'fn_team_member_posttype' );

add_action( 'init', 'create_team_member_category', 0 );
function create_team_member_category() {
    register_taxonomy(
        'team-member-category',
        'team-member',
        array(
            'labels' => array(
                'name' => 'Team Member Category',
                'add_new_item' => 'Add New Category',
                'new_item_name' => "New Category"
            ),
            'show_ui' => true,
            'show_tagcloud' => false,
            'hierarchical' => true
			
        )
    );
}

function fn_service_posttype() { 
	register_post_type( 'service',

		array(
			'labels' => array(
				'name' => __( 'Services' ),
				'singular_name' => __( 'Service')
			),
			'public' => true,
			'has_archive' => true,
			'rewrite' => array('slug' => 'service','with_front' => false), 
			'supports' => array( 'title', 'revisions','editor','excerpt','thumbnail' ),
			
		)
	);
}
add_action( 'init', 'fn_service_posttype' );


function fn_services_listing(){
$exclude=get_the_ID();
$args = array( 
				'posts_per_page' => -1,
				'post_type' =>'service',
				'post_status' =>'publish',
				'orderby' => 'date', 
				'order' => 'ASC',
				'post__not_in' => array($exclude),
				
			);
	$the_query = new WP_Query( $args );
	ob_start();
	if ( $the_query->have_posts() ) {
	?>	<h2 class="section-title">Our Services</h2>
		<ul class="custom-sv-list">
		<?php	while ( $the_query->have_posts() ) : $the_query->the_post(); ?>
			<li><h3><a href="<?php the_permalink(); ?>"><span><?php the_title(); ?></span></a></h3></li>
		<?php	endwhile;	?>
		</ul>
	<?php
	}
	return ob_get_clean();
	wp_reset_postdata();
}
add_shortcode("services_listing","fn_services_listing"); 
/****************************************************************/

function fn_goggle_scripts_customizer( $wp_customize ) {           
  
    /* Google GA section */
        $wp_customize->add_section( 
            'theme_slug_customizer_your_section0', 
            array(
                'title' => esc_html__( 'Google GA, GTM and Meta codes', 'dental' ),
                'priority' => 150
            )
        );      
          
             
    /* script input sanitization function */
        function theme_slug_sanitize_js_code0($input){
            return base64_encode($input);
        }
         
         
    /* output escape function     */
        function theme_slug_escape_js_output0($input){
            return esc_textarea( base64_decode($input) );
        }
         
                  
    /* add setting to your section */
        $wp_customize->add_setting( 
             'google_js_code',  
            array(          
                'sanitize_callback' => 'theme_slug_sanitize_js_code0', /* encode for DB insert */
                'sanitize_js_callback' => 'theme_slug_escape_js_output0' /*  script for the textarea */
            )
        );
         
        $wp_customize->add_control( 
             'google_js_code', 
            array(
                'label' => esc_html__( 'SEO Codes and Google Scripts', 'dental' ),
                'section' => 'theme_slug_customizer_your_section0',
                'type' => 'textarea'
            )
        );         
      
}
add_action( 'customize_register', 'fn_goggle_scripts_customizer' );

/****************************************************************/

function fn_header_scripts_customizer( $wp_customize ) {           
  
    /* your section */
        $wp_customize->add_section( 
            'theme_slug_customizer_your_section1', 
            array(
                'title' => esc_html__( 'Additional Header Scripts', 'dental' ),
                'priority' => 150
            )
        );      
          
             
    /* script input sanitization function */
        function theme_slug_sanitize_js_code1($input){
            return base64_encode($input);
        }
         
         
    /* output escape function     */
        function theme_slug_escape_js_output1($input){
            return esc_textarea( base64_decode($input) );
        }
         
                  
    /* add setting to your section */
        $wp_customize->add_setting( 
             'header_js_code',  
            array(          
                'sanitize_callback' => 'theme_slug_sanitize_js_code1', /* encode for DB insert */
                'sanitize_js_callback' => 'theme_slug_escape_js_output1' /*  script for the textarea */
            )
        );
         
        $wp_customize->add_control( 
             'header_js_code', 
            array(
                'label' => esc_html__( 'JavaScript code', 'dental' ),
                'section' => 'theme_slug_customizer_your_section1',
                'type' => 'textarea'
            )
        );         
      
}
add_action( 'customize_register', 'fn_header_scripts_customizer' );

/****************************************************************/


function fn_body_scripts_customizer( $wp_customize ) {           
  
    /* your section */
        $wp_customize->add_section( 
            'theme_slug_customizer_your_section2', 
            array(
                'title' => esc_html__( 'Additional Body Scripts', 'dental' ),
                'priority' => 151
            )
        );      
          
             
    /* script input sanitization function */
        function theme_slug_sanitize_js_code2($input){
            return base64_encode($input);
        }
         
         
    /* output escape function     */
        function theme_slug_escape_js_output2($input){
            return esc_textarea( base64_decode($input) );
        }
         
                  
    /* add setting to your section */
        $wp_customize->add_setting( 
            'body_js_code', 
            array(          
                'sanitize_callback' => 'theme_slug_sanitize_js_code2', /* encode for DB insert */
                'sanitize_js_callback' => 'theme_slug_escape_js_output2' /*  script for the textarea */
            )
        );
         
        $wp_customize->add_control( 
            'body_js_code', 
            array(
                'label' => esc_html__( 'JavaScript code', 'dental' ),
                'section' => 'theme_slug_customizer_your_section2',
                'type' => 'textarea'
            )
        );         
      
}
add_action( 'customize_register', 'fn_body_scripts_customizer' );

/****************************************************************/

function fn_footer_scripts_customizer( $wp_customize ) {           
  
    /* Additional Footer section */
        $wp_customize->add_section( 
            'theme_slug_customizer_your_section3', 
            array(
                'title' => esc_html__( 'Additional Footer Scripts', 'dental' ),
                'priority' => 151
            )
        );      
          
             
    /* script input sanitization function */
        function theme_slug_sanitize_js_code3($input){
            return base64_encode($input);
        }
         
         
    /* output escape function  */
        function theme_slug_escape_js_output3($input){
            return esc_textarea( base64_decode($input) );
        }
         
                  
    /* add setting to your section */
        $wp_customize->add_setting( 
            'footer_js_code', 
            array(          
                'sanitize_callback' => 'theme_slug_sanitize_js_code3', /* encode for DB insert */
                'sanitize_js_callback' => 'theme_slug_escape_js_output3' /*  script for the textarea */
            )
        );
         
        $wp_customize->add_control( 
            'footer_js_code', 
            array(
                'label' => esc_html__( 'JavaScript code', 'dental' ),
                'section' => 'theme_slug_customizer_your_section3',
                'type' => 'textarea'
            )
        );         
      
}
add_action( 'customize_register', 'fn_footer_scripts_customizer' );

/*Recent Blog Section*/
function fn_recent_blogs(){
$args = array( 
				'posts_per_page' => 5,
				'post_type' =>'post',
				'post_status' =>'publish',
				'orderby' => 'date', 
				'order' => 'DESC',
				
			);
		$the_query = new WP_Query( $args );
		ob_start();
		?>
		<div class="recent-post-section">
		<h2 class="widget-title">Recent Blogs</h2>
			<ul>
				<?php
				while ( $the_query->have_posts() ) : $the_query->the_post();
				 ?>
					<li class="list">
						<div class="postcontent">
						
						<a href="<?php the_permalink(); ?>" class="recent-post-image">
							<div style="background-image: url(<?php echo get_the_post_thumbnail_url(); ?>);"></div>
						</a>
						<div class="post_info"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></div>
						</div>
					</li>
				 <?php
				endwhile;
				?>
			</ul>			
		</div>
		

<?php
return ob_get_clean();
wp_reset_postdata();
}
add_shortcode("recent_blogs","fn_recent_blogs"); 

/*  Recent Blog Shortcode : [recent_blogs] */
/***************************************************************************************************/

function fn_homepage_slider(){
	ob_start();
?>
<section class="homepage-slider-main">
	
	<div class="homepage-slider">
		<?php 
		if( have_rows('slide') ):
		$counter=1;
			while ( have_rows('slide') ) : the_row();  
			
			$content_position=get_sub_field("content_position");
			$background_position=get_sub_field("background_position");
			$background_size=get_sub_field("background_size");
			$overlay_option=get_sub_field("overlay_option");
			if(get_sub_field("overlay_color")){
				$overlay_color=get_sub_field("overlay_color");
			}else{
				$overlay_color='transparent';
			}
		?>
		<div class="slide-main slide<?php echo $counter; ?>" style="background:url(<?php the_sub_field("slide_image"); ?>) no-repeat <?php echo $background_position; ?>; background-size: <?php echo $background_size; ?>">
			<img src="<?php echo get_sub_field("slide_mobile_image"); ?>" class="mobile-slide d-block d-md-none" alt="mobile slide" >
			<div class="slide-inner content-on-<?php echo $content_position; ?>  <?php echo $overlay_option; ?> " style="background-color: <?php echo $overlay_color; ?>">
	
				<?php if(get_sub_field('slide_heading')){ ?>
				<h2><?php the_sub_field("slide_heading"); ?></h2>
				<?php } ?>
				
				<?php if(get_sub_field('slide_sub_heading')){ ?>
				<div class="sub-heading-text"><?php the_sub_field("slide_sub_heading"); ?></div>
				<?php } ?>
				
				<?php if( get_sub_field('button_1_text') && get_sub_field('button_2_text')){ ?>
				<div class="slide-both-btns slider-btns">
					<a href="<?php echo get_sub_field('button_1_url'); ?>" class="slide-btn-1"><?php echo get_sub_field('button_1_text'); ?></a>
					<a href="<?php echo get_sub_field('button_2_url'); ?>" class="slide-btn-2"><?php echo get_sub_field('button_2_text'); ?></a>
				</div>
				
				<?php }elseif( get_sub_field('button_1_text') && !get_sub_field('button_2_text')){ ?>
				<div class="slide-only-btn1 slider-btns">
					<a href="<?php echo get_sub_field('button_1_url'); ?>" class="slide-btn-1"><?php echo get_sub_field('button_1_text'); ?></a>
				</div>
				
				<?php }elseif( !get_sub_field('button_1_text') && get_sub_field('button_2_text')){ ?>
				<div class="slide-only-btn2 slider-btns">
					<a href="<?php echo get_sub_field('button_2_url'); ?>" class="slide-btn-2"><?php echo get_sub_field('button_2_text'); ?></a>
				</div>
				
				<?php }else{ 
					/*No Buttons*/
				 } ?>
	
			</div>
		</div>
		<?php 	
		$counter++;
		endwhile;

		else :

			// no rows found

		endif;
		?>	
				
	</div>
</section>

<?php
return ob_get_clean();
}
add_shortcode("homepage_slider","fn_homepage_slider"); 


 
add_filter( 'excerpt_length', function($length) {    return 50; 	} ); 
add_filter( 'excerpt_more', function($more) {    return ' ... '; 	} ); 